<?php

require_once "../../../controladores/cobros.controlador.php";
require_once "../../../modelos/cobros.modelo.php";

require_once "../../../controladores/personas.controlador.php";
require_once "../../../modelos/personas.modelo.php";

require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";

class imprimirTicket{

public $codigo;
public $idcobros;

public function traerImpresionTicket(){

date_default_timezone_set("America/Mx");
setlocale(LC_ALL, 'spanish');
//TRAEMOS LA INFORMACIÓN DE LA VENTA

$itemContrata = "idcobros";
$valorContrata = $this->idcobros;

$urlBase = "https://diplomadosmt.com/sicose_v5/extensiones/tcpdf/pdf/ticket.php?idcobros=";
$urlCompleta = $urlBase . $itemContrata;

$respuestaContrata = ControladorCobros::ctrMostrarCobrosReporte($itemContrata, $valorContrata);

// Verificar que la respuesta sea válida
if(!is_array($respuestaContrata) || empty($respuestaContrata)){
	die("Error: No se encontraron datos para el cobro solicitado.");
}

$fechaActual = date("Y-m-d H:i:s");

$idresponsable = $respuestaContrata[0]['idresponsable'] ?? null;
$usuario = null;
$nombreCobrador = "";
if($idresponsable !== null){
	$usuario = ControladorUsuarios::ctrMostrarUsuarios('id', $idresponsable);
	if(is_array($usuario) && isset($usuario['nombre'])){
		$nombreCobrador = $usuario['nombre'];
	}
}

$codigo = $respuestaContrata[0]["codigoA"] ?? '';
$mpago =  $respuestaContrata[0]["mpago"] ?? '';
$fecha_cobro_temp = $respuestaContrata[0]["fecha_cobro"] ?? '';
$fecha = $fecha_cobro_temp ? substr($fecha_cobro_temp, 0, -8) : '';
//$estado = json_decode($respuestaContrata["estado"], true);
$tipo = $respuestaContrata[0]["tipo"] ?? '';

$nombreCliente = $respuestaContrata[0]["nombres"] ?? '';
$direccion_cli = $respuestaContrata[0]["direccion"] ?? '';
$documento_cli = $respuestaContrata[0]["documento"] ?? '';
$telefono_cli = $respuestaContrata[0]["telefono"] ?? '';

$plantilla = new ControladorPlantilla();
$configuracionArray = $plantilla -> ctrConfiguracion();
if(!is_array($configuracionArray) || empty($configuracionArray)){
	die("Error: No se pudo cargar la configuración.");
}
$configuracion = $configuracionArray[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion_conf =  $configuracion['direccion'];
$tasa_cambio =  $configuracion['cambio'];

$valorServicio = $respuestaContrata[0]["valor_servicio"] ?? 0;
$total_temp = $respuestaContrata[0]["total"] ?? 0;
$subtotal = number_format($total_temp, 2, '.', ',');
$total = number_format($total_temp, 2, '.', ',');
$codigo2 =  $respuestaContrata[0]["codigoR"] ?? '';

$notitas =  $respuestaContrata[0]["notitas"] ?? '';
$banco =  $respuestaContrata[0]["banco"] ?? '';
$fecha_cobro_temp2 = $respuestaContrata[0]["fecha_cobro"] ?? '';
$fecha_cobro = $fecha_cobro_temp2 ? substr($fecha_cobro_temp2, 0, -8) : '';

$estadoPago = "";
$estado_pago_valor = $respuestaContrata[0]["estado_pago"] ?? 0;

if($estado_pago_valor == 0){
	$estadoPago = "PENDIENTE";
		//$valor = "---------";
}else if($estado_pago_valor == 1){
	$estadoPago = "PAGADO";
		//$total += $value["valor_servicio"];
}else if ($estado_pago_valor == 2){
	$estadoPago = "VENCIDO";
		//$valor = "S/.00.00";
}

$recargo = "00.00";
$recargo_valor = $respuestaContrata[0]["recargo"] ?? 0;

if ($recargo_valor == 1){
	$recargo = "Q.5.00";
	$subtotal = number_format((float)str_replace(',', '', $subtotal) - 5, 2, '.', ',');
}

$codigoTicket = "";
$codigoR_temp = $respuestaContrata[0]["codigoR"] ?? 0;

if($codigoR_temp != 0 && $codigoR_temp != ''){
	$codigoTicket = "<b>SERIE:</b> R - ".$codigoR_temp;
}else{
	$codigoTicket = "<b>SERIE:</b> A - ".$codigo;
}

//TRAEMOS LA INFORMACIÓN DEL CLIENTE
/*
$itemCliente = "idpersona";
$valorCliente = $respuestaContrata["idpersona"];

$respuestaCliente = ControladorPersonas::ctrMostrarPersonas($itemCliente, $valorCliente);
*/




//TRAEMOS LA INFORMACIÓN DEL VENDEDOR

$itemUsuario = "id";
$valorUsuario = $respuestaContrata[0]["idusuario"] ?? null;

$respuestaUsuario = null;
$nombreUsuario = "";
if($valorUsuario !== null){
	$respuestaUsuario = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);
	if(is_array($respuestaUsuario) && isset($respuestaUsuario['nombre'])){
		$nombreUsuario = $respuestaUsuario['nombre'];
	}
}

//REQUERIMOS LA CLASE TCPDF

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);



//calcular las medidas para el tick;
$altura = 400;
$cantidad_contratos = count($respuestaContrata);

$altura = (12 * $cantidad_contratos) + $altura;
//echo $altura; exit;
$medidas = array(80, $altura); // Ajustar aqui segun los milimetros necesarios;
//$pdf = new TCPDF('P', 'mm', $medidas, true, 'UTF-8', false);

$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

$pdf->AddPage('P', $medidas);

//---------------------------------------------------------
$nombreEmpresa = "<h1>$razon_social</h1> <br><b>Teléfono:</b> $prefijo $celular <br>
<b>Correo:</b> $email <br> <b>Dirección:</b> $direccion_conf";









$bloque1 = <<<EOF

<table  style="font-size:8px; text-align:center;">
	<tr>
		<td style="width:160px;">
			<img src="../../../$logo" style="width: 140px;">
		</td>
	</tr>

	<tr>
		<td style="width:160px;">
			<div>
				$nombreEmpresa
				<br>
				<b>FOLIO N°:</b> $codigo
				<br>
				<b>FECHA DE COBRO°:</b> $fecha_cobro
				<br>
				<b>REF Ban°:</b> $codigo2
				<br>
				<b>Metodo:</b> $mpago
				<br>
				<b>Nota:</b> $notitas
				<br>
				<b>Banco:</b> $banco
				<br>
				<b>COBRADOR:</b> $nombreCobrador
				<br><br>
				<b>DATOS CLIENTE</b> 
				<br>Nombre: $nombreCliente 
				<br>Diplomado: $direccion_cli
				<br>Id de alumno: $documento_cli
				<br>Teléfono: $telefono_cli
				<br>
			</div>
		</td>

	</tr>


</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

$bloque2 = <<<EOF
<hr><br>
<table  style="font-size:8px;">
	<tr>
		<td style="width:70px;">
			<b>Servicio</b>
		</td>
		<td>
			<b>fecha de pago</b>
		</td>
		<td>
			<b>Total</b>
		</td>
	</tr>
</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');


$arrayIdServicios = array();
foreach ($respuestaContrata as $key => $value) {

	//traemos la información de los meses pendientes segun tipo servicio

	$servicio = $value["servicio"] ?? '';
	$tipoServicio = $value["descripcion"] ?? '';
	$fecha_pago_temp = $value["fechas_pagos"] ?? '';
	$fechaPm = $fecha_pago_temp ? strtotime($fecha_pago_temp) : time();

	$mes  = date("d/m/Y", $fechaPm);

	$valor = number_format($value["valor_servicio"] ?? 0, 2, '.', ',');

	//Consulto cuantos meses le falta segun el tipo del servicio
	$idservicio = $value["idservicios"] ?? null;
	if($idservicio !== null && !in_array($idservicio, $arrayIdServicios)){
		$sumaMeses = 0;
		$respuestaMesesFaltantes = ControladorCobros::ctrMesesFlatantes($idservicio);
		if ($respuestaMesesFaltantes != null && is_array($respuestaMesesFaltantes)){
			$numromeses = $respuestaMesesFaltantes["numromeses"] ?? 0;
			$cont = $respuestaMesesFaltantes["cont"] ?? 0;
			$sumaMeses = $numromeses - $cont;
		}
		array_push($arrayIdServicios, $idservicio, [
			"servicio" => $servicio,
			"numeroMeses" => $sumaMeses
			]);
	}

$bloque3 = <<<EOF

<table  style="font-size:8px;">
	<tr>
		<td style="width:80px;">
			$servicio
		</td>
		<td>
			$mes
		</td>
		<td>
			$ $total
		</td>
	</tr>
</table>
EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');
}


$bloque5 = <<<EOF
<br>
<hr>
<table  style="font-size:10px; text-align:rigth;">
	<tr>
		<td style="width:160px;">
			<div>
				<!--
				<b>Fecha de Pago:</b> $fecha

				<br>

				<br>
				<b>Recargo:</b> $recargo

				<br>
				<b>Valor:</b> Q.$total.00-->

				<br>
				<b>Subtotal:</b>$ $subtotal

				<br>
				<b>Recargo:</b>$ $recargo


				<br>
				<b>Total:</b>$ $total .00


			</div>

		</td>

	</tr>


</table>

EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');


$bloque6 = <<<EOF

<table  style="font-size:10px; text-align:center;">
	<tr>
		<td style="width:160px;">
			<div>
				Agradecemos tu puntualidad. <br>
				Tu próximo pago es:<br>
				Este pago no incluye IVA; <br>
				en caso de requerir factura recuerde solicitarla dentro del mes en que lo realizó al 221 113 3151<br>

			</div>
		</td>
	</tr>
</table>

EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');

// Construir la URL completa con el ID variable
$urlBase = "https://diplomadosmt.com/sicose_v5/extensiones/tcpdf/pdf/ticket.php?idcobros=";
$urlCompleta = $urlBase . $valorContrata;

// Configurar el estilo del código QR
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0, 0, 0),
    'bgcolor' => array(255, 255, 255),
    'module_width' => 1,
    'module_height' => 1
);

// Generar el código QR
$pdf->write2DBarcode($urlCompleta, 'QRCODE,L', 20, $pdf->getY() + 5, 40, 40, $style, 'N');



// ---------------------------------------------------------
//SALIDA DEL ARCHIVO

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('factura.pdf');

// /*=============================================
// IMPRIMIR ESTADO DE COMPROBANTE
// =============================================*/





// ---------------------------------------------------------
//SALIDA DEL ARCHIVO

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('factura.pdf');

}

}

$factura = new imprimirTicket();
$factura -> idcobros = $_GET["idcobros"];
$factura -> traerImpresionTicket();

?>
